IF OBJECT_ID('V_PARCIAL_TOP_VENDEDORES') IS NOT NULL
	DROP VIEW V_PARCIAL_TOP_VENDEDORES
GO

CREATE VIEW V_PARCIAL_TOP_VENDEDORES
AS
    SELECT	TOP 10 
                I.CD_FILIAL AS FILIAL,I.CD_VEND AS CODIGO,V.NM_FUN AS DESCRICAO,COUNT(0) AS QTDE,SUM(TOT_IT) AS TOTAL,ROUND(SUM(TOT_IT) / COUNT(0),2) AS TICKET
    FROM	PDV_VD C 
    INNER	JOIN PDV_VD_IT I
    ON          C.CD_EMP = I.CD_EMP AND C.CD_FILIAL = I.CD_FILIAL AND C.CD_VD = I.CD_VD AND C.DT_VD = I.DT_VD
    INNER	JOIN FP_FUNC V ON I.CD_VEND = V.CD_FUN
    WHERE	C.DT_VD = CONVERT(VARCHAR,GETDATE(),112) AND C.ST_VD = 0 AND I.ST_IT = 1
    GROUP	BY I.CD_FILIAL,I.CD_VEND,V.NM_FUN
    ORDER	BY TOTAL DESC